<?php include PATH_VIEW . '/layout/header.tpl'; ?>

<div id="ajaxArea">
    <div class="container bg-body-tertiary p-3">
        <div class="row">
            <div class="col-md-8">
                <section id="column1" class="mb-4 podcast">

                    <section id="breadcrumb" class="border-bottom mb-4">
                        <?php include PATH_VIEW . '/layout/breadcrumb.tpl' ?>
                    </section>

                    <article itemscope itemtype="https://schema.org/NewsArticle">

                        <div class="d-flex flex-sm-row flex-column">
                            <div class="mb-3 mb-md-0 me-3 text-center">
                                <img itemprop="image" loading="lazy" src="<?php echo $og_image; ?>" class="rounded " alt="<?php echo $item->title; ?>">
                            </div>

                            <div class="">
                                <h1 itemprop="headline" class="title-post"><?php echo $item->title; ?></h1>
                                <p itemprop="description" class="mb-0"><?php echo $item->description; ?></p>
                            </div>
                        </div>

                        <div class="d-flex justify-content-between align-items-center flex-sm-row flex-column mb-4">
                            <div class="mt-3">

                                <span itemprop="datePublished" content="<?php echo $item->date_post ?>"><?php echo FormatDate($setting->format_date . ' ' . $setting->format_time, $item->date_post); ?><span>
                                        <?php if ($item->updated) { ?>
                                            <span itemprop="dateModified" content="<?php echo $item->updated; ?>"> | <?php echo $_LANG['updated_at']; ?> <?php echo elapsedTime($item->updated); ?><span>
                                                <?php } ?>
                            </div>
                            <div class="mt-3" id="shareBS" data-url="<?php echo $og_url; ?>" data-title="<?php echo $og_title; ?>"></div>
                        </div>

                        <h2 class="mb-3"><?php echo $_LANG['available_episodes']; ?></h2>

                        <?php if ($itemList) { ?>

                            <ul class="list-group list-group-flush rounded">
                                <?php foreach ($itemList as $i) { ?>
                                    <?php $countEp = $countEp - 1; ?>
                                    <li class="list-group-item list-group-item-action" aria-current="true">
                                        <div class="d-flex w-100 justify-content-between align-items-center">
                                            <span class="number"><?php echo $countEp; ?></span>
                                            <button class="b-play" aria-label="<?php echo $_LANG['play_audio']; ?>" <?php echo getAudioPodcast($i->type, $i->podcast_id, $i->audio_url); ?>></button>
                                            <span class="flex-fill me-4 fw-bold"><?php echo $i->title; ?></span>
                                            <small><?php echo elapsedTime($i->date_post); ?></small>
                                        </div>
                                    </li>
                                <?php } ?>

                            </ul>
                        <?php } else { ?>
                            <div class="alert alert-danger" role="alert">
                                <?php echo $_LANG['empty'] ?>
                            </div>
                        <?php } ?>

                    </article>

                    <?php include PATH_VIEW . '/layout/comments.tpl'; ?>

                </section>
            </div>

            <div class="col-md-4">
                <aside>
                    <section id="column2" class="row">
                        <?php
                        // widgets column 2
                        include PATH_VIEW . '/layout/search.tpl';
                        include PATH_VIEW . '/layout/category.tpl';

                        $widgetPos = 4;
                        include PATH_VIEW . '/layout/widget.tpl';
                        ?>
                    </section>
                </aside>
            </div>

        </div>

    </div>

</div>

<?php include PATH_VIEW . '/layout/footer.tpl'; ?>
